/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.govern.core.listener;

import io.lettuce.core.pubsub.RedisPubSubListener;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import io.lettuce.core.pubsub.api.async.RedisPubSubAsyncCommands;
import java.util.concurrent.CompletableFuture;
import me.ahoo.govern.core.listener.AbstractMessageListenable;
import me.ahoo.govern.core.listener.ChannelTopic;
import me.ahoo.govern.core.listener.PatternTopic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisMessageListenable
extends AbstractMessageListenable {
    private static final Logger log = LoggerFactory.getLogger(RedisMessageListenable.class);
    private final StatefulRedisPubSubConnection<String, String> pubSubConnection;
    private final RedisPubSubAsyncCommands<String, String> pubSubCommands;
    private final RedisPubSubListenerAdapter listenerAdapter;

    public RedisMessageListenable(StatefulRedisPubSubConnection<String, String> pubSubConnection) {
        this.pubSubConnection = pubSubConnection;
        this.pubSubCommands = pubSubConnection.async();
        this.listenerAdapter = new RedisPubSubListenerAdapter();
        this.pubSubConnection.addListener((RedisPubSubListener)this.listenerAdapter);
    }

    @Override
    public void close() throws Exception {
        this.pubSubConnection.close();
    }

    @Override
    protected CompletableFuture<Void> subscribe(ChannelTopic channelTopic) {
        return this.pubSubCommands.subscribe((Object[])new String[]{channelTopic.getTopic()}).toCompletableFuture();
    }

    @Override
    protected CompletableFuture<Void> subscribe(PatternTopic patternTopic) {
        return this.pubSubCommands.psubscribe((Object[])new String[]{patternTopic.getTopic()}).toCompletableFuture();
    }

    @Override
    protected CompletableFuture<Void> unsubscribe(ChannelTopic topic) {
        return this.pubSubCommands.unsubscribe((Object[])new String[]{topic.getTopic()}).toCompletableFuture();
    }

    @Override
    protected CompletableFuture<Void> unsubscribe(PatternTopic topic) {
        return this.pubSubCommands.punsubscribe((Object[])new String[]{topic.getTopic()}).toCompletableFuture();
    }

    private class RedisPubSubListenerAdapter
    implements RedisPubSubListener<String, String> {
        private RedisPubSubListenerAdapter() {
        }

        public void message(String channel, String message) {
            if (log.isDebugEnabled()) {
                log.debug("Message received from a channel subscription - channel[{}] | message[{}]", (Object)channel, (Object)message);
            }
            RedisMessageListenable.this.onMessage(channel, message, null);
        }

        public void message(String pattern, String channel, String message) {
            if (log.isDebugEnabled()) {
                log.debug("Message received from a pattern subscription - pattern[{}] | channel[{}] | message[{}]", new Object[]{pattern, channel, message});
            }
            RedisMessageListenable.this.onMessage(channel, message, pattern);
        }

        public void subscribed(String channel, long count) {
            if (log.isInfoEnabled()) {
                log.info("Subscribed to a channel - channel[{}] | [{}]", (Object)channel, (Object)count);
            }
        }

        public void psubscribed(String pattern, long count) {
            if (log.isInfoEnabled()) {
                log.info("PSubscribed to a pattern - pattern[{}] | [{}]", (Object)pattern, (Object)count);
            }
        }

        public void unsubscribed(String channel, long count) {
            if (log.isInfoEnabled()) {
                log.info("Unsubscribed from a channel - channel[{}] | [{}]", (Object)channel, (Object)count);
            }
        }

        public void punsubscribed(String pattern, long count) {
            if (log.isInfoEnabled()) {
                log.info("PUnsubscribed from a pattern - pattern[{}] | [{}]", (Object)pattern, (Object)count);
            }
        }
    }
}

