/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.govern.core.redis;

import io.lettuce.core.cluster.api.async.RedisClusterAsyncCommands;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import me.ahoo.govern.core.NamespaceService;

public class RedisNamespaceService
implements NamespaceService {
    private static final String NAMESPACE_IDX_KEY = "govern-{system}:ns_idx";
    private final RedisClusterAsyncCommands<String, String> redisCommands;

    public RedisNamespaceService(RedisClusterAsyncCommands<String, String> redisCommands) {
        this.redisCommands = redisCommands;
    }

    @Override
    public CompletableFuture<Set<String>> getNamespaces() {
        return this.redisCommands.smembers((Object)NAMESPACE_IDX_KEY).toCompletableFuture();
    }

    @Override
    public CompletableFuture<Boolean> setNamespace(String namespace) {
        return this.redisCommands.sadd((Object)NAMESPACE_IDX_KEY, (Object[])new String[]{namespace}).thenApply(affected -> affected > 0L).toCompletableFuture();
    }

    @Override
    public CompletableFuture<Boolean> removeNamespace(String namespace) {
        return this.redisCommands.srem((Object)NAMESPACE_IDX_KEY, (Object[])new String[]{namespace}).thenApply(affected -> affected > 0L).toCompletableFuture();
    }
}

