/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.govern.core.redis;

import io.lettuce.core.AbstractRedisClient;
import io.lettuce.core.RedisChannelHandler;
import io.lettuce.core.RedisConnectionStateListener;
import java.io.Closeable;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import me.ahoo.govern.core.util.RedisScripts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisScriptInitializer
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(RedisScriptInitializer.class);
    private final AbstractRedisClient redisClient;
    private final RedisStateListener redisStateListener;

    public RedisScriptInitializer(AbstractRedisClient redisClient) {
        this.redisClient = redisClient;
        this.redisStateListener = new RedisStateListener();
        redisClient.addListener((RedisConnectionStateListener)this.redisStateListener);
    }

    @Override
    public void close() throws IOException {
        this.redisClient.removeListener((RedisConnectionStateListener)this.redisStateListener);
    }

    public class RedisStateListener
    implements RedisConnectionStateListener {
        private final Set<Object> connectedMap = ConcurrentHashMap.newKeySet();

        public void onRedisDisconnected(RedisChannelHandler<?, ?> connection) {
        }

        public void onRedisConnected(RedisChannelHandler<?, ?> connection, SocketAddress socketAddress) {
            boolean added = this.connectedMap.add(connection);
            if (!added) {
                if (log.isWarnEnabled()) {
                    log.warn("onRedisConnected - [{}] - [{}] - RedisScripts.clearScript.", connection, (Object)socketAddress);
                }
                RedisScripts.clearScript();
            }
        }

        public void onRedisExceptionCaught(RedisChannelHandler<?, ?> connection, Throwable cause) {
            log.error("onRedisExceptionCaught.", cause);
        }
    }
}

