/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.govern.core.util;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import me.ahoo.govern.core.GovernException;

public final class Futures {
    private Futures() {
    }

    public static <T> T getUnChecked(Future<T> future, Duration timeout) {
        try {
            return future.get(timeout.toNanos(), TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new GovernException(e);
        }
        catch (TimeoutException e) {
            throw new GovernException(e);
        }
        catch (ExecutionException e) {
            throw new GovernException(e);
        }
    }
}

