/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.govern.core.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.lettuce.core.api.sync.RedisServerCommands;
import java.util.Map;
import me.ahoo.govern.core.GovernException;

@Deprecated
public final class RedisKeySpaces {
    public static final String KEY_SPACE_TOPIC_PREFIX_FORMAT = "__keyspace@%s__:";
    public static final String KEY_SPACE_TOPIC_FORMAT = "__keyspace@%s__:%s";
    private static final String NOTIFY_KEYSPACE_EVENTS = "notify-keyspace-events";
    private static final String KEY_SPACE_TYPE = "K";
    private static final String KEY_EVENT_TYPE = "E";
    private static final String ALL_DATA_TYPE = "A";
    private static final String[] DATA_TYPES = new String[]{"g", "$", "s", "h", "x"};
    private static final int DEFAULT_DB = 0;

    public static String getTopicOfKey(String key) {
        return RedisKeySpaces.getTopicOfKey(0, key);
    }

    public static String getTopicOfKey(int db, String key) {
        return Strings.lenientFormat((String)KEY_SPACE_TOPIC_FORMAT, (Object[])new Object[]{db, key});
    }

    public static String getKeyOfChannel(String channel) {
        return RedisKeySpaces.getKeyOfChannel(0, channel);
    }

    public static String getKeyOfChannel(int db, String channel) {
        String keyspaceTopicPrefix = Strings.lenientFormat((String)KEY_SPACE_TOPIC_PREFIX_FORMAT, (Object[])new Object[]{db});
        return channel.substring(keyspaceTopicPrefix.length());
    }

    public static void ensureEnableKeyspace(String notifyKeySpaceEventsConfigValue) {
        if (!notifyKeySpaceEventsConfigValue.contains(KEY_SPACE_TYPE)) {
            throw new GovernException(Strings.lenientFormat((String)"ensureEnableKeyspace - Redis config [%s] must has value [%s].", (Object[])new Object[]{NOTIFY_KEYSPACE_EVENTS, KEY_SPACE_TYPE}));
        }
    }

    public static void ensureNotifyKeyspaceEvents(RedisServerCommands<String, String> redisServerCommands) {
        Map config = redisServerCommands.configGet(NOTIFY_KEYSPACE_EVENTS);
        String configVal = (String)config.get(NOTIFY_KEYSPACE_EVENTS);
        Preconditions.checkNotNull((Object)configVal);
        RedisKeySpaces.ensureNotifyKeyspaceEvents(configVal);
    }

    public static void ensureNotifyKeyspaceEvents(String notifyKeySpaceEventsConfigValue) {
        RedisKeySpaces.ensureEnableKeyspace(notifyKeySpaceEventsConfigValue);
        if (notifyKeySpaceEventsConfigValue.contains(ALL_DATA_TYPE)) {
            return;
        }
        StringBuilder missConfigValue = new StringBuilder();
        for (String dataType : DATA_TYPES) {
            if (notifyKeySpaceEventsConfigValue.contains(dataType)) continue;
            missConfigValue.append(dataType);
        }
        if (missConfigValue.length() > 0) {
            throw new GovernException(Strings.lenientFormat((String)"ensureNotifyKeyspaceEvents - Redis config [%s] must has value [%s].", (Object[])new Object[]{NOTIFY_KEYSPACE_EVENTS, missConfigValue.toString()}));
        }
    }
}

