/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.govern.core.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.RedisNoScriptException;
import io.lettuce.core.ScriptOutputType;
import io.lettuce.core.api.async.RedisScriptingAsyncCommands;
import io.lettuce.core.internal.Exceptions;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public final class RedisScripts {
    private static final String WARN_CLEAR_TEST_DATA = "warn_clear_test_data.lua";
    public static final ConcurrentHashMap<String, CompletableFuture<String>> scriptMapSha = new ConcurrentHashMap();

    private RedisScripts() {
    }

    public static String getScript(String scriptName) {
        URL url = Resources.getResource((String)scriptName);
        return Resources.toString((URL)url, (Charset)Charsets.UTF_8);
    }

    public static void clearScript() {
        scriptMapSha.clear();
    }

    public static CompletableFuture<String> loadScript(String scriptName, RedisScriptingAsyncCommands<String, String> scriptingCommands) {
        return scriptMapSha.computeIfAbsent(scriptName, key -> {
            String script = RedisScripts.getScript(key);
            return scriptingCommands.scriptLoad(script).toCompletableFuture();
        });
    }

    public static CompletableFuture<String> reloadScript(String scriptName, RedisScriptingAsyncCommands<String, String> scriptingCommands) {
        return scriptMapSha.compute(scriptName, (key, result) -> {
            String script = RedisScripts.getScript(key);
            return scriptingCommands.scriptLoad(script).toCompletableFuture();
        });
    }

    public static <T> CompletableFuture<T> doEnsureScript(String scriptName, RedisScriptingAsyncCommands<String, String> scriptingCommands, Function<String, RedisFuture<T>> doSha) {
        return RedisScripts.loadScript(scriptName, scriptingCommands).thenCompose(sha -> {
            RedisFuture doFuture = (RedisFuture)doSha.apply((String)sha);
            doFuture.exceptionally(throwable -> {
                if (Exceptions.unwrap((Throwable)throwable) instanceof RedisNoScriptException) {
                    RedisScripts.reloadScript(scriptName, scriptingCommands);
                }
                throw Exceptions.bubble((Throwable)throwable);
            });
            return doFuture.toCompletableFuture();
        });
    }

    @Deprecated
    @VisibleForTesting
    public static CompletableFuture<Void> clearTestData(String namespace, RedisScriptingAsyncCommands<String, String> scriptingCommands) {
        return RedisScripts.loadScript(WARN_CLEAR_TEST_DATA, scriptingCommands).thenCompose(sha -> scriptingCommands.evalsha(sha, ScriptOutputType.STATUS, (Object[])new String[]{namespace}));
    }
}

