/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.govern.discovery.redis;

import io.lettuce.core.RedisFuture;
import io.lettuce.core.ScriptOutputType;
import io.lettuce.core.cluster.api.async.RedisClusterAsyncCommands;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArraySet;
import me.ahoo.govern.core.NamespacedContext;
import me.ahoo.govern.discovery.NamespacedServiceInstance;
import me.ahoo.govern.discovery.RegistryProperties;
import me.ahoo.govern.discovery.ServiceInstance;
import me.ahoo.govern.discovery.ServiceInstanceCodec;
import me.ahoo.govern.discovery.ServiceRegistry;
import me.ahoo.govern.discovery.redis.DiscoveryRedisScripts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisServiceRegistry
implements ServiceRegistry {
    private static final Logger log = LoggerFactory.getLogger(RedisServiceRegistry.class);
    private final RegistryProperties registryProperties;
    private final RedisClusterAsyncCommands<String, String> redisCommands;
    private final CopyOnWriteArraySet<NamespacedServiceInstance> registeredEphemeralInstances = new CopyOnWriteArraySet();

    public RedisServiceRegistry(RegistryProperties registryProperties, RedisClusterAsyncCommands<String, String> redisCommands) {
        this.registryProperties = registryProperties;
        this.redisCommands = redisCommands;
    }

    private CompletableFuture<Boolean> register0(String namespace, String scriptSha, ServiceInstance serviceInstance) {
        Object[] keys = new String[]{namespace};
        String[] infoArgs = new String[]{serviceInstance.isEphemeral() ? String.valueOf(this.registryProperties.getInstanceTtl()) : "-1", serviceInstance.getServiceId(), serviceInstance.getInstanceId(), serviceInstance.getSchema(), serviceInstance.getIp(), String.valueOf(serviceInstance.getPort()), String.valueOf(serviceInstance.getWeight())};
        Object[] values = ServiceInstanceCodec.encodeMetadata(infoArgs, serviceInstance.getMetadata());
        RedisFuture redisFuture = this.redisCommands.evalsha(scriptSha, ScriptOutputType.BOOLEAN, keys, values);
        return redisFuture.toCompletableFuture();
    }

    @Override
    public CompletableFuture<Boolean> setService(String namespace, String serviceId) {
        if (log.isInfoEnabled()) {
            log.info("setService - serviceId:[{}]  @ namespace:[{}].", (Object)serviceId, (Object)namespace);
        }
        return DiscoveryRedisScripts.loadRegistrySetService(this.redisCommands).thenCompose(sha -> this.redisCommands.evalsha(sha, ScriptOutputType.BOOLEAN, (Object[])new String[]{namespace}, (Object[])new String[]{serviceId}));
    }

    @Override
    public CompletableFuture<Boolean> removeService(String namespace, String serviceId) {
        if (log.isInfoEnabled()) {
            log.info("removeService - serviceId:[{}]  @ namespace:[{}].", (Object)serviceId, (Object)namespace);
        }
        return DiscoveryRedisScripts.loadRegistryRemoveService(this.redisCommands).thenCompose(sha -> this.redisCommands.evalsha(sha, ScriptOutputType.BOOLEAN, (Object[])new String[]{namespace}, (Object[])new String[]{serviceId}));
    }

    @Override
    public CompletableFuture<Boolean> register(ServiceInstance serviceInstance) {
        return this.register(NamespacedContext.GLOBAL.getNamespace(), serviceInstance);
    }

    @Override
    public CompletableFuture<Boolean> register(String namespace, ServiceInstance serviceInstance) {
        if (log.isInfoEnabled()) {
            log.info("register - instanceId:[{}]  @ namespace:[{}].", (Object)serviceInstance.getInstanceId(), (Object)namespace);
        }
        this.addEphemeralInstance(namespace, serviceInstance);
        return DiscoveryRedisScripts.loadRegistryRegister(this.redisCommands).thenCompose(sha -> this.register0(namespace, (String)sha, serviceInstance));
    }

    private void addEphemeralInstance(String namespace, ServiceInstance serviceInstance) {
        if (!serviceInstance.isEphemeral()) {
            return;
        }
        this.registeredEphemeralInstances.add(NamespacedServiceInstance.of(namespace, serviceInstance));
    }

    private void removeEphemeralInstance(String namespace, String instanceId) {
        Optional<NamespacedServiceInstance> serviceInstanceOp = this.registeredEphemeralInstances.stream().filter(namespacedServiceInstance -> namespacedServiceInstance.getNamespace().equals(namespace) && instanceId.equals(namespacedServiceInstance.getServiceInstance().getInstanceId())).findFirst();
        if (serviceInstanceOp.isPresent()) {
            this.registeredEphemeralInstances.remove(serviceInstanceOp.get());
        }
    }

    private void removeEphemeralInstance(String namespace, ServiceInstance serviceInstance) {
        if (!serviceInstance.isEphemeral()) {
            return;
        }
        this.registeredEphemeralInstances.remove(NamespacedServiceInstance.of(namespace, serviceInstance));
    }

    @Override
    public Set<NamespacedServiceInstance> getRegisteredEphemeralInstances() {
        return this.registeredEphemeralInstances;
    }

    @Override
    public CompletableFuture<Boolean> setMetadata(String serviceId, String instanceId, String key, String value) {
        return this.setMetadata(NamespacedContext.GLOBAL.getNamespace(), serviceId, instanceId, key, value);
    }

    @Override
    public CompletableFuture<Boolean> setMetadata(String namespace, String serviceId, String instanceId, String key, String value) {
        String[] values = new String[]{instanceId, key, value};
        return this.setMetadata0(namespace, instanceId, values);
    }

    @Override
    public CompletableFuture<Boolean> setMetadata(String serviceId, String instanceId, Map<String, String> metadata) {
        return this.setMetadata(NamespacedContext.GLOBAL.getNamespace(), serviceId, instanceId, metadata);
    }

    @Override
    public CompletableFuture<Boolean> setMetadata(String namespace, String serviceId, String instanceId, Map<String, String> metadata) {
        String[] values = ServiceInstanceCodec.encodeMetadata(new String[]{instanceId}, metadata);
        return this.setMetadata0(namespace, instanceId, values);
    }

    private CompletableFuture<Boolean> setMetadata0(String namespace, String instanceId, String[] args) {
        if (log.isInfoEnabled()) {
            log.info("setMetadata - instanceId:[{}] @ namespace:[{}].", (Object)instanceId, (Object)namespace);
        }
        String[] keys = new String[]{namespace};
        return DiscoveryRedisScripts.loadRegistrySetMetadata(this.redisCommands).thenCompose(sha -> this.redisCommands.evalsha(sha, ScriptOutputType.BOOLEAN, (Object[])keys, (Object[])args));
    }

    @Override
    public CompletableFuture<Boolean> renew(ServiceInstance serviceInstance) {
        return this.renew(NamespacedContext.GLOBAL.getNamespace(), serviceInstance);
    }

    @Override
    public CompletableFuture<Boolean> renew(String namespace, ServiceInstance serviceInstance) {
        if (log.isInfoEnabled()) {
            log.info("renew - instanceId:[{}] @ namespace:[{}].", (Object)serviceInstance.getInstanceId(), (Object)namespace);
        }
        if (!serviceInstance.isEphemeral()) {
            log.warn("renew - instanceId:[{}] @ namespace:[{}] is not ephemeral, can not renew.", (Object)serviceInstance.getInstanceId(), (Object)namespace);
            return CompletableFuture.completedFuture(Boolean.FALSE);
        }
        String[] keys = new String[]{namespace};
        String[] values = new String[]{serviceInstance.getInstanceId(), String.valueOf(this.registryProperties.getInstanceTtl())};
        return DiscoveryRedisScripts.loadRegistryRenew(this.redisCommands).thenCompose(sha -> this.redisCommands.evalsha(sha, ScriptOutputType.BOOLEAN, (Object[])keys, (Object[])values));
    }

    @Override
    public CompletableFuture<Boolean> deregister(String serviceId, String instanceId) {
        return this.deregister(NamespacedContext.GLOBAL.getNamespace(), serviceId, instanceId);
    }

    @Override
    public CompletableFuture<Boolean> deregister(String namespace, String serviceId, String instanceId) {
        if (log.isInfoEnabled()) {
            log.info("deregister - instanceId:[{}] @ namespace:[{}].", (Object)instanceId, (Object)namespace);
        }
        this.removeEphemeralInstance(namespace, instanceId);
        return this.deregister0(namespace, serviceId, instanceId);
    }

    private CompletableFuture<Boolean> deregister0(String namespace, String serviceId, String instanceId) {
        return DiscoveryRedisScripts.loadRegistryDeregister(this.redisCommands).thenCompose(sha -> {
            Object[] keys = new String[]{namespace};
            Object[] values = new String[]{serviceId, instanceId};
            RedisFuture redisFuture = this.redisCommands.evalsha(sha, ScriptOutputType.BOOLEAN, keys, values);
            return redisFuture;
        });
    }

    @Override
    public CompletableFuture<Boolean> deregister(ServiceInstance serviceInstance) {
        return this.deregister(NamespacedContext.GLOBAL.getNamespace(), serviceInstance);
    }

    @Override
    public CompletableFuture<Boolean> deregister(String namespace, ServiceInstance serviceInstance) {
        if (log.isInfoEnabled()) {
            log.info("deregister - instanceId:[{}] @ namespace:[{}].", (Object)serviceInstance.getInstanceId(), (Object)namespace);
        }
        this.removeEphemeralInstance(namespace, serviceInstance);
        return this.deregister0(namespace, serviceInstance.getServiceId(), serviceInstance.getInstanceId());
    }
}

