/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.govern.discovery.loadbalancer;

import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import me.ahoo.govern.discovery.ServiceInstance;
import me.ahoo.govern.discovery.loadbalancer.AbstractLoadBalancer;
import me.ahoo.govern.discovery.loadbalancer.LoadBalancer;
import me.ahoo.govern.discovery.redis.ConsistencyRedisServiceDiscovery;

public class RandomLoadBalancer
extends AbstractLoadBalancer<RandomChooser> {
    public RandomLoadBalancer(ConsistencyRedisServiceDiscovery serviceDiscovery) {
        super(serviceDiscovery);
    }

    @Override
    protected RandomChooser createChooser(List<ServiceInstance> serviceInstances) {
        return new RandomChooser(serviceInstances);
    }

    public static class RandomChooser
    implements LoadBalancer.Chooser {
        private final List<ServiceInstance> serviceInstances;

        public RandomChooser(List<ServiceInstance> serviceInstances) {
            this.serviceInstances = serviceInstances;
        }

        @Override
        public ServiceInstance choose() {
            if (this.serviceInstances.isEmpty()) {
                return null;
            }
            if (this.serviceInstances.size() == 1) {
                return this.serviceInstances.get(0);
            }
            int randomIdx = ThreadLocalRandom.current().nextInt(this.serviceInstances.size());
            return this.serviceInstances.get(randomIdx);
        }
    }
}

