/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.govern.discovery;

import com.google.common.base.Strings;

public final class DiscoveryKeyGenerator {
    private static final String SERVICE_IDX = "svc_idx";
    private static final String SERVICE_STAT = "svc_stat";
    private static final String SERVICE_INSTANCE_IDX = "svc_itc_idx";
    private static final String SERVICE_INSTANCE = "svc_itc";
    private static final String serviceIdxKeyFormat = "%s:svc_idx";
    private static final String serviceStatKeyFormat = "%s:svc_stat";
    private static final String instanceIdxKeyFormat = "%s:svc_itc_idx:%s";
    private static final String instanceKeyFormat = "%s:svc_itc:%s";
    private static final String instanceKeyPrefixFormat = "%s:svc_itc:";
    private static final String instanceKeyPatternOfNamespaceFormat = "%s:svc_itc:*";
    private static final String instanceKeyPatternOfServiceFormat = "%s:svc_itc:%s@*";

    private DiscoveryKeyGenerator() {
    }

    public static String getServiceIdxKey(String namespace) {
        return Strings.lenientFormat((String)serviceIdxKeyFormat, (Object[])new Object[]{namespace});
    }

    public static String getServiceStatKey(String namespace) {
        return Strings.lenientFormat((String)serviceStatKeyFormat, (Object[])new Object[]{namespace});
    }

    public static String getNamespaceOfKey(String key) {
        int firstSplitIdx = key.indexOf(":");
        return key.substring(0, firstSplitIdx);
    }

    public static String getInstanceIdxKey(String namespace, String serviceId) {
        return Strings.lenientFormat((String)instanceIdxKeyFormat, (Object[])new Object[]{namespace, serviceId});
    }

    public static String getInstanceKey(String namespace, String instanceId) {
        return Strings.lenientFormat((String)instanceKeyFormat, (Object[])new Object[]{namespace, instanceId});
    }

    public static String getInstanceKeyPatternOfNamespace(String namespace) {
        return Strings.lenientFormat((String)instanceKeyPatternOfNamespaceFormat, (Object[])new Object[]{namespace});
    }

    public static String getInstanceKeyPatternOfService(String namespace, String serviceId) {
        return Strings.lenientFormat((String)instanceKeyPatternOfServiceFormat, (Object[])new Object[]{namespace, serviceId});
    }

    public static String getInstanceIdOfKey(String namespace, String instanceKey) {
        String instanceKeyPrefix = Strings.lenientFormat((String)instanceKeyPrefixFormat, (Object[])new Object[]{namespace});
        return instanceKey.substring(instanceKeyPrefix.length());
    }
}

