/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.govern.discovery;

import com.google.common.base.Strings;
import me.ahoo.govern.discovery.Instance;

public interface InstanceIdGenerator {
    public static final Default DEFAULT = new Default();

    public String generate(Instance var1);

    public static class Default
    implements InstanceIdGenerator {
        public static final String ID_FORMAT = "%s@%s#%s#%s";

        @Override
        public String generate(Instance instance) {
            return Strings.lenientFormat((String)ID_FORMAT, (Object[])new Object[]{instance.getServiceId(), instance.getSchema(), instance.getHost(), instance.getPort()});
        }

        public Instance of(String instanceId) {
            Instance instance = new Instance();
            instance.setInstanceId(instanceId);
            String[] serviceSpits = instanceId.split("@");
            if (serviceSpits.length != 2) {
                throw new IllegalArgumentException(Strings.lenientFormat((String)"instanceId:[%s] format error.", (Object[])new Object[]{instanceId}));
            }
            instance.setServiceId(serviceSpits[0]);
            String[] instanceSpits = serviceSpits[1].split("#");
            if (instanceSpits.length != 3) {
                throw new IllegalArgumentException(Strings.lenientFormat((String)"instanceId:[%s] format error.", (Object[])new Object[]{instanceId}));
            }
            instance.setSchema(instanceSpits[0]);
            instance.setHost(instanceSpits[1]);
            instance.setPort(Integer.parseInt(instanceSpits[2]));
            return instance;
        }
    }
}

