/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.govern.discovery.redis;

import com.google.common.base.Strings;
import com.google.common.primitives.Ints;
import io.lettuce.core.ScriptOutputType;
import io.lettuce.core.cluster.api.async.RedisClusterAsyncCommands;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import me.ahoo.govern.core.listener.MessageListenable;
import me.ahoo.govern.core.listener.MessageListener;
import me.ahoo.govern.core.listener.PatternTopic;
import me.ahoo.govern.core.listener.Topic;
import me.ahoo.govern.discovery.DiscoveryKeyGenerator;
import me.ahoo.govern.discovery.Instance;
import me.ahoo.govern.discovery.InstanceIdGenerator;
import me.ahoo.govern.discovery.ServiceStat;
import me.ahoo.govern.discovery.ServiceStatistic;
import me.ahoo.govern.discovery.redis.DiscoveryRedisScripts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisServiceStatistic
implements ServiceStatistic {
    private static final Logger log = LoggerFactory.getLogger(RedisServiceStatistic.class);
    private final RedisClusterAsyncCommands<String, String> redisCommands;
    private final MessageListenable messageListenable;
    private final InstanceListener instanceListener;
    private final ConcurrentHashMap<String, Object> listenedNamespaces = new ConcurrentHashMap();
    private static final Object NONE = new Object();

    public RedisServiceStatistic(RedisClusterAsyncCommands<String, String> redisCommands, MessageListenable messageListenable) {
        this.redisCommands = redisCommands;
        this.messageListenable = messageListenable;
        this.instanceListener = new InstanceListener();
    }

    private void startListeningServiceInstancesOfNamespace(String namespace) {
        this.listenedNamespaces.computeIfAbsent(namespace, ns -> {
            String instancePattern = DiscoveryKeyGenerator.getInstanceKeyPatternOfNamespace(namespace);
            PatternTopic instanceTopic = PatternTopic.of((String)instancePattern);
            this.messageListenable.addListener((Topic)instanceTopic, (MessageListener)this.instanceListener);
            return NONE;
        });
    }

    @Override
    public CompletableFuture<Void> statService(String namespace) {
        this.startListeningServiceInstancesOfNamespace(namespace);
        return this.statService0(namespace, null);
    }

    @Override
    public CompletableFuture<Void> statService(String namespace, String serviceId) {
        return this.statService0(namespace, serviceId);
    }

    private CompletableFuture<Void> statService0(String namespace, String serviceId) {
        if (log.isInfoEnabled()) {
            log.info("statService  @ namespace:[{}].", (Object)namespace);
        }
        String[] keys = new String[]{namespace};
        String[] values = !Strings.isNullOrEmpty((String)serviceId) ? new String[]{serviceId} : new String[]{};
        return DiscoveryRedisScripts.doServiceStat(this.redisCommands, sha -> this.redisCommands.evalsha(sha, ScriptOutputType.STATUS, (Object[])keys, (Object[])values));
    }

    public CompletableFuture<Long> countService(String namespace) {
        String serviceIdxStatKey = DiscoveryKeyGenerator.getServiceStatKey(namespace);
        return this.redisCommands.hlen((Object)serviceIdxStatKey).toCompletableFuture();
    }

    @Override
    public CompletableFuture<List<ServiceStat>> getServiceStats(String namespace) {
        String serviceIdxStatKey = DiscoveryKeyGenerator.getServiceStatKey(namespace);
        return this.redisCommands.hgetall((Object)serviceIdxStatKey).thenApply(statMap -> statMap.entrySet().stream().map(stat -> {
            ServiceStat serviceStat = new ServiceStat();
            serviceStat.setServiceId((String)stat.getKey());
            serviceStat.setInstanceCount(Ints.tryParse((String)((String)stat.getValue())));
            return serviceStat;
        }).collect(Collectors.toList())).toCompletableFuture();
    }

    @Override
    public CompletableFuture<Long> getInstanceCount(String namespace) {
        return DiscoveryRedisScripts.loadInstanceCountStat(this.redisCommands).thenCompose(sha -> this.redisCommands.evalsha(sha, ScriptOutputType.INTEGER, (Object[])new String[]{namespace}));
    }

    private class InstanceListener
    implements MessageListener {
        private InstanceListener() {
        }

        public void onMessage(Topic topic, String channel, String message) {
            if (log.isInfoEnabled()) {
                log.info("onMessage@InstanceListener - topic:[{}] - channel:[{}] - message:[{}]", new Object[]{topic, channel, message});
            }
            if ("renew".equals(message)) {
                return;
            }
            String instanceKey = channel;
            String namespace = DiscoveryKeyGenerator.getNamespaceOfKey(instanceKey);
            String instanceId = DiscoveryKeyGenerator.getInstanceIdOfKey(namespace, instanceKey);
            Instance instance = InstanceIdGenerator.DEFAULT.of(instanceId);
            String serviceId = instance.getServiceId();
            RedisServiceStatistic.this.statService0(namespace, serviceId);
        }
    }
}

