/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.pigeon.connector.starter.core;

import com.google.common.base.Preconditions;
import me.ahoo.cosky.discovery.spring.cloud.registry.CoskyRegistration;
import me.ahoo.pigeon.connector.core.ChannelContextFilter;
import me.ahoo.pigeon.connector.core.ChannelContextSelector;
import me.ahoo.pigeon.connector.core.ClientAckService;
import me.ahoo.pigeon.connector.core.MessageDispatcher;
import me.ahoo.pigeon.connector.core.ServerAckService;
import me.ahoo.pigeon.connector.core.handler.DefaultChannelHandler;
import me.ahoo.pigeon.connector.core.internal.ConnectorLifeCycle;
import me.ahoo.pigeon.connector.core.internal.DefaultChannelContextSelector;
import me.ahoo.pigeon.connector.core.internal.DefaultClientAckService;
import me.ahoo.pigeon.connector.core.internal.DefaultMessageDispatcher;
import me.ahoo.pigeon.connector.core.internal.DefaultServerAckService;
import me.ahoo.pigeon.connector.core.internal.OgnlChannelContextFilter;
import me.ahoo.pigeon.connector.core.internal.none.NoneClientAckService;
import me.ahoo.pigeon.connector.core.internal.none.NoneServerAckService;
import me.ahoo.pigeon.connector.core.mbean.ChannelContextStat;
import me.ahoo.pigeon.connector.core.mbean.ChannelContextStatMBean;
import me.ahoo.pigeon.connector.core.mbean.ConnectorStat;
import me.ahoo.pigeon.connector.core.mbean.ConnectorStatMBean;
import me.ahoo.pigeon.connector.core.mbean.DeviceStat;
import me.ahoo.pigeon.connector.core.mbean.DeviceStatMBean;
import me.ahoo.pigeon.connector.core.mbean.MBeanRegister;
import me.ahoo.pigeon.connector.core.mbean.RoomStat;
import me.ahoo.pigeon.connector.core.mbean.RoomStatMBean;
import me.ahoo.pigeon.connector.core.mbean.UserStat;
import me.ahoo.pigeon.connector.core.mbean.UserStatMBean;
import me.ahoo.pigeon.connector.core.registry.ChannelContextRegistry;
import me.ahoo.pigeon.connector.core.registry.DeviceRegistry;
import me.ahoo.pigeon.connector.core.registry.RoomRegistry;
import me.ahoo.pigeon.connector.core.registry.UserRegistry;
import me.ahoo.pigeon.connector.core.registry.impl.ChannelContextRegistryImpl;
import me.ahoo.pigeon.connector.core.registry.impl.DeviceRegistryImpl;
import me.ahoo.pigeon.connector.core.registry.impl.RoomRegistryImpl;
import me.ahoo.pigeon.connector.core.registry.impl.UserRegistryImpl;
import me.ahoo.pigeon.connector.core.subscriber.ConnectorSubscriber;
import me.ahoo.pigeon.connector.core.util.MessageBusSupport;
import me.ahoo.pigeon.connector.starter.core.ConnectorProperties;
import me.ahoo.pigeon.connector.starter.core.ConnectorRegistrationProcessor;
import me.ahoo.pigeon.connector.starter.netty.NettyProperties;
import me.ahoo.pigeon.core.bus.MessageBus;
import me.ahoo.pigeon.core.connector.ConnectorId;
import me.ahoo.pigeon.core.connector.StatefulSetConnectorIdProvider;
import me.ahoo.pigeon.core.id.IdGenerator;
import me.ahoo.pigeon.core.relation.ConnectorUserRelationService;
import me.ahoo.pigeon.core.relation.DeviceConnectorRelationService;
import me.ahoo.pigeon.core.relation.RoomConnectorRelationService;
import me.ahoo.pigeon.core.relation.UserConnectorRelationService;
import me.ahoo.pigeon.core.security.authorization.DeviceAuthorization;
import me.ahoo.pigeon.core.security.authorization.RoomAuthorization;
import me.ahoo.pigeon.core.security.authorization.UserAuthorization;
import me.ahoo.pigeon.core.security.command.CommandAuthorization;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={ConnectorProperties.class})
public class ConnectorAutoConfiguration {
    private final ConnectorProperties connectorProperties;

    public ConnectorAutoConfiguration(ConnectorProperties connectorProperties) {
        this.connectorProperties = connectorProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public ConnectorId connectorId() {
        if (this.connectorProperties.isEnableStatefulSetId()) {
            return new StatefulSetConnectorIdProvider().get();
        }
        ConnectorId connectorId = new ConnectorId();
        Preconditions.checkNotNull((Object)this.connectorProperties.getId(), (Object)"pigeon.connector.id can not be null.");
        connectorId.setId(this.connectorProperties.getId().intValue());
        Preconditions.checkArgument((connectorId.getId() >= 0 ? 1 : 0) != 0, (Object)"pigeon.connector.id can not be  less than 0.");
        return connectorId;
    }

    @Bean
    public ConnectorRegistrationProcessor connectorRegistrationProcessor(ConnectorId connectorId, NettyProperties nettyProperties, CoskyRegistration registration) {
        return new ConnectorRegistrationProcessor(this.connectorProperties, nettyProperties, connectorId, registration);
    }

    @Bean
    @ConditionalOnMissingBean
    public ChannelContextSelector channelContextSelector(ConnectorId connectorId, ChannelContextRegistry channelContextRegistry, DeviceRegistry deviceRegistry, UserRegistry userRegistry, RoomRegistry roomRegistry, ChannelContextFilter channelContextFilter, ConnectorUserRelationService connectorUserRelationService) {
        return new DefaultChannelContextSelector(connectorId, channelContextRegistry, deviceRegistry, userRegistry, roomRegistry, channelContextFilter, connectorUserRelationService);
    }

    @Bean
    @ConditionalOnMissingBean
    public MessageDispatcher messageDispatcher(ChannelContextSelector channelContextSelector) {
        return new DefaultMessageDispatcher(channelContextSelector);
    }

    @Bean
    @ConditionalOnMissingBean
    public ChannelContextFilter channelFilter() {
        return new OgnlChannelContextFilter();
    }

    @Bean
    @ConditionalOnMissingBean
    public ConnectorSubscriber connectorSubscriber(MessageDispatcher messageDispatcher) {
        return new ConnectorSubscriber(messageDispatcher);
    }

    @Bean
    @ConditionalOnMissingBean
    public MessageBusSupport messageBusSupport(ConnectorId connectorId, MessageBus messageBus, IdGenerator idGenerator) {
        return new MessageBusSupport(connectorId, messageBus, idGenerator);
    }

    @Bean
    @ConditionalOnMissingBean
    public ServerAckService serverAckService() {
        if (this.connectorProperties.getAck().isEnableServer()) {
            return new DefaultServerAckService(this.connectorProperties.getAck());
        }
        return new NoneServerAckService();
    }

    @Bean
    @ConditionalOnMissingBean
    public ClientAckService clientAckService() {
        if (this.connectorProperties.getAck().isEnableClient()) {
            return new DefaultClientAckService(this.connectorProperties.getAck());
        }
        return new NoneClientAckService();
    }

    @Bean
    @ConditionalOnMissingBean
    public DefaultChannelHandler internalHandler(MessageBusSupport messageBusSupport, CommandAuthorization commandAuthorization, DeviceAuthorization deviceAuthorization, UserAuthorization userAuthorization, RoomAuthorization roomAuthorization, ChannelContextRegistry channelContextRegistry, DeviceRegistry deviceRegistry, UserRegistry userRegistry, RoomRegistry roomRegistry, ServerAckService serverAckService, ClientAckService clientAckService) {
        return new DefaultChannelHandler(messageBusSupport, commandAuthorization, deviceAuthorization, userAuthorization, roomAuthorization, channelContextRegistry, deviceRegistry, userRegistry, roomRegistry, serverAckService, clientAckService);
    }

    @Bean
    @ConditionalOnMissingBean
    public ConnectorLifeCycle connectorLifeCycle(ConnectorId connectorId, IdGenerator idGenerator, MessageBus messageBus, ConnectorUserRelationService connectorUserRelationService) {
        return new ConnectorLifeCycle(connectorId, idGenerator, messageBus, connectorUserRelationService);
    }

    @Bean
    @ConditionalOnMissingBean
    public ChannelContextRegistry channelRegistry() {
        return new ChannelContextRegistryImpl();
    }

    @Bean
    @ConditionalOnMissingBean
    public DeviceRegistry deviceRegistry(ConnectorId connectorId, DeviceConnectorRelationService deviceConnectorRelationService, MessageBusSupport messageBusSupport) {
        return new DeviceRegistryImpl(connectorId, deviceConnectorRelationService, messageBusSupport);
    }

    @Bean
    @ConditionalOnMissingBean
    public UserRegistry userRegistry(ConnectorId connectorId, UserConnectorRelationService userConnectorRelationService, ConnectorUserRelationService connectorUserRelationService, MessageBusSupport messageBusSupport) {
        return new UserRegistryImpl(connectorId, userConnectorRelationService, connectorUserRelationService, messageBusSupport);
    }

    @Bean
    @ConditionalOnMissingBean
    public RoomRegistry roomRegistry(ConnectorId connectorId, RoomConnectorRelationService roomConnectorRelationService, MessageBusSupport messageBusSupport) {
        return new RoomRegistryImpl(connectorId, roomConnectorRelationService, messageBusSupport);
    }

    @Bean
    @Primary
    public ConnectorStatMBean connectorStatMBean(ChannelContextRegistry channelContextRegistry, DeviceRegistry deviceRegistry, UserRegistry userRegistry, RoomRegistry roomRegistry) {
        return new ConnectorStat(channelContextRegistry, deviceRegistry, userRegistry, roomRegistry);
    }

    @Bean
    @Primary
    public ChannelContextStatMBean channelStatMBean(ChannelContextRegistry channelContextRegistry) {
        return new ChannelContextStat(channelContextRegistry);
    }

    @Bean
    @Primary
    public DeviceStatMBean deviceStatMBean(DeviceRegistry deviceRegistry) {
        return new DeviceStat(deviceRegistry);
    }

    @Bean
    @Primary
    public UserStatMBean userStatMBean(UserRegistry userRegistry) {
        return new UserStat(userRegistry);
    }

    @Bean
    @Primary
    public RoomStatMBean roomStatMBean(RoomRegistry roomRegistry) {
        return new RoomStat(roomRegistry);
    }

    @Bean
    @ConditionalOnMissingBean
    public MBeanRegister mBeanRegister(ConnectorStatMBean connectorStatMBean, ChannelContextStatMBean channelContextStatMBean, UserStatMBean userStatMBean, DeviceStatMBean deviceStatMBean, RoomStatMBean roomStatMBean) {
        return new MBeanRegister(connectorStatMBean, channelContextStatMBean, userStatMBean, deviceStatMBean, roomStatMBean);
    }
}

