/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.pigeon.connector.starter.core;

import com.google.common.base.Strings;
import java.util.Map;
import java.util.Objects;
import javax.annotation.PostConstruct;
import me.ahoo.cosky.discovery.Instance;
import me.ahoo.cosky.discovery.InstanceIdGenerator;
import me.ahoo.cosky.discovery.ServiceInstance;
import me.ahoo.cosky.discovery.spring.cloud.registry.CoskyRegistration;
import me.ahoo.pigeon.connector.core.config.Connector;
import me.ahoo.pigeon.connector.core.config.Expose;
import me.ahoo.pigeon.connector.discovery.ConnectorDiscovery;
import me.ahoo.pigeon.connector.starter.netty.NettyProperties;
import me.ahoo.pigeon.core.connector.ConnectorId;
import me.ahoo.pigeon.core.expression.SpringExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectorRegistrationProcessor {
    private static final Logger log = LoggerFactory.getLogger(ConnectorRegistrationProcessor.class);
    private final Connector connector;
    private final NettyProperties nettyProperties;
    private final ConnectorId connectorId;
    private final CoskyRegistration registration;

    public ConnectorRegistrationProcessor(Connector connector, NettyProperties nettyProperties, ConnectorId connectorId, CoskyRegistration registration) {
        this.connector = connector;
        this.nettyProperties = nettyProperties;
        this.connectorId = connectorId;
        this.registration = registration;
    }

    @PostConstruct
    public void process() {
        ServiceInstance instance = this.registration.of();
        if (instance.getPort() == 0) {
            instance.setPort(this.connector.getPort());
        }
        if (Objects.nonNull(this.nettyProperties.getSsl())) {
            instance.setSchema("wss");
        } else {
            instance.setSchema("ws");
        }
        this.processExpose();
        ConnectorDiscovery.setConnectorId((Map)this.registration.getMetadata(), (int)this.connectorId.getId());
        instance.setInstanceId(InstanceIdGenerator.DEFAULT.generate((Instance)instance));
    }

    private void processExpose() {
        String host;
        Expose expose = this.connector.getExpose();
        if (Objects.isNull(expose) && log.isWarnEnabled()) {
            log.warn("pigeon.connector.expose is null,skip setting connector.expose.");
            return;
        }
        Map connectorMetadata = this.registration.getMetadata();
        if (!Strings.isNullOrEmpty((String)expose.getSchema())) {
            ConnectorDiscovery.setConnectorExposeSchema((Map)connectorMetadata, (String)expose.getSchema());
        }
        if (!Objects.isNull(expose.getPort())) {
            ConnectorDiscovery.setConnectorExposePort((Map)connectorMetadata, (int)expose.getPort());
        }
        if (Strings.isNullOrEmpty((String)(host = expose.getHost())) && !Strings.isNullOrEmpty((String)expose.getHostTemplate())) {
            SpringExpression stringExpression = new SpringExpression(expose.getHostTemplate());
            host = stringExpression.parse((Object)this.connectorId);
        }
        if (!Strings.isNullOrEmpty((String)host)) {
            ConnectorDiscovery.setConnectorExposeHost((Map)this.registration.getMetadata(), (String)host);
        }
    }
}

