/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.pigeon.connector.starter.netty;

import com.google.common.base.Preconditions;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.kqueue.KQueue;
import io.netty.handler.ssl.SslContext;
import javax.annotation.Nullable;
import me.ahoo.pigeon.connector.core.ChannelHandler;
import me.ahoo.pigeon.connector.core.config.Connector;
import me.ahoo.pigeon.connector.core.server.ConnectorServer;
import me.ahoo.pigeon.connector.netty.NettyChannel;
import me.ahoo.pigeon.connector.netty.codec.MessageToTextWebSocketFrameEncoder;
import me.ahoo.pigeon.connector.netty.codec.TextWebSocketFrameToMessageDecoder;
import me.ahoo.pigeon.connector.netty.config.Netty;
import me.ahoo.pigeon.connector.netty.config.Ssl;
import me.ahoo.pigeon.connector.netty.handler.ChannelContextInitializer;
import me.ahoo.pigeon.connector.netty.handler.ChildHandlerInitializer;
import me.ahoo.pigeon.connector.netty.handler.CloseIdleChannelHandler;
import me.ahoo.pigeon.connector.netty.handler.DispatcherChannelHandler;
import me.ahoo.pigeon.connector.netty.handler.RateLimiterHandler;
import me.ahoo.pigeon.connector.netty.server.EpollNetty;
import me.ahoo.pigeon.connector.netty.server.KQueueNetty;
import me.ahoo.pigeon.connector.netty.server.NioNetty;
import me.ahoo.pigeon.connector.netty.util.Ssls;
import me.ahoo.pigeon.connector.starter.netty.NettyProperties;
import me.ahoo.pigeon.core.codec.MessageToStringEncoder;
import me.ahoo.pigeon.core.codec.StringToMessageDecoder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={NettyChannel.class})
@EnableConfigurationProperties(value={NettyProperties.class})
public class NettyAutoConfiguration {
    private final NettyProperties nettyProperties;

    public NettyAutoConfiguration(NettyProperties nettyProperties) {
        this.nettyProperties = nettyProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public ConnectorServer connectorServer(ConfigurableApplicationContext applicationContext, Connector connectorConfig, Netty nettyConfig, ChildHandlerInitializer childHandlerInitializer) {
        if (Epoll.isAvailable()) {
            return new EpollNetty(applicationContext, connectorConfig, nettyConfig, childHandlerInitializer);
        }
        if (KQueue.isAvailable()) {
            return new KQueueNetty(applicationContext, connectorConfig, nettyConfig, childHandlerInitializer);
        }
        return new NioNetty(applicationContext, connectorConfig, nettyConfig, childHandlerInitializer);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="pigeon.connector.netty", name={"ssl.certFile"})
    public SslContext nettySslContext() {
        Ssl sslConfig = this.nettyProperties.getSsl();
        Preconditions.checkNotNull((Object)sslConfig, (Object)"Ssl can not be null!");
        Preconditions.checkNotNull((Object)sslConfig.getCertFile(), (Object)"Ssl.certFile can not be null!");
        Preconditions.checkNotNull((Object)sslConfig.getKeyFile(), (Object)"Ssl.keyFile can not be null!");
        return Ssls.forServer((Ssl)sslConfig);
    }

    @Bean
    @ConditionalOnMissingBean
    public MessageToTextWebSocketFrameEncoder messageToTextWebSocketFrameEncoder(MessageToStringEncoder messageToStringEncoder) {
        return new MessageToTextWebSocketFrameEncoder(messageToStringEncoder);
    }

    @Bean
    @ConditionalOnMissingBean
    public TextWebSocketFrameToMessageDecoder textWebSocketFrameToMessageDecoder(StringToMessageDecoder stringToMessageDecoder) {
        return new TextWebSocketFrameToMessageDecoder(stringToMessageDecoder);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="pigeon.connector.netty", name={"limiter.enable"}, havingValue="true")
    public RateLimiterHandler rateLimiterHandler() {
        return new RateLimiterHandler(this.nettyProperties.getLimiter());
    }

    @Bean
    @ConditionalOnMissingBean
    public CloseIdleChannelHandler closeIdleChannelHandler() {
        return new CloseIdleChannelHandler();
    }

    @Bean
    @ConditionalOnMissingBean
    public ChannelContextInitializer channelInfoHandler(ChannelHandler channelHandler) {
        return new ChannelContextInitializer(channelHandler);
    }

    @Bean
    @ConditionalOnMissingBean
    public DispatcherChannelHandler dispatcherChannelHandler() {
        return new DispatcherChannelHandler();
    }

    @Bean
    @ConditionalOnMissingBean
    public ChildHandlerInitializer childHandlerInitializer(@Nullable SslContext sslContext, @Nullable RateLimiterHandler rateLimiterHandler, ChannelContextInitializer channelContextInitializer, CloseIdleChannelHandler closeIdleChannelHandler, TextWebSocketFrameToMessageDecoder textWebSocketFrameToMessageDecoder, MessageToTextWebSocketFrameEncoder messageToTextWebSocketFrameEncoder, DispatcherChannelHandler dispatcherChannelHandler) {
        return new ChildHandlerInitializer((Netty)this.nettyProperties, sslContext, rateLimiterHandler, channelContextInitializer, closeIdleChannelHandler, textWebSocketFrameToMessageDecoder, messageToTextWebSocketFrameEncoder, dispatcherChannelHandler);
    }
}

