package me.ahoo.pigeon.core;

import java.time.LocalDateTime;
import java.time.ZoneOffset;

/**
 * @author ahoo wang
 * Creation time: 2019/12/2 17:00
 */
public final class Constants {
    public static final String PIGEON = "pigeon";
    public static final String PIGEON_PREFIX = PIGEON + ".";
    public static final LocalDateTime PIGEON_EPOCH_DATE;
    public static final long PIGEON_EPOCH;
    public static final long PIGEON_EPOCH_SECOND;

    static {
        PIGEON_EPOCH_DATE = LocalDateTime.of(2019, 12, 24, 16, 0);
        PIGEON_EPOCH = PIGEON_EPOCH_DATE.toInstant(ZoneOffset.UTC).toEpochMilli();
        PIGEON_EPOCH_SECOND = PIGEON_EPOCH / 1000;
    }
}
