package me.ahoo.pigeon.core.bus;

import lombok.var;
import me.ahoo.pigeon.core.bus.subscriber.Subscriber;
import me.ahoo.pigeon.core.message.Message;
import me.ahoo.pigeon.core.util.Threads;

import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/**
 * @author ahoo wang
 * Creation time: 2019/11/22 15:14
 */
public interface Dispatcher {
    Dispatcher DEFAULT = new Default();

    void dispatch(Message message, Set<Subscriber> subscribers);

    class Default implements Dispatcher {

        private final ExecutorService executorService;

        public Default() {
            var threadFactory = Threads.defaultFactory("Dispatcher-DEFAULT");
            var corePoolSize = Threads.defaultCorePoolSize();
            this.executorService = new ThreadPoolExecutor(corePoolSize, corePoolSize,
                    0L, TimeUnit.MILLISECONDS,
                    new LinkedBlockingQueue<Runnable>(), threadFactory);
        }

        @Override
        public void dispatch(Message message, Set<Subscriber> subscribers) {
            subscribers.forEach(subscriber -> {
                executorService.execute(() -> subscriber.invoke(message));
            });
        }
    }
}
