package me.ahoo.pigeon.core.bus;


import me.ahoo.pigeon.core.bus.subscriber.Subscriber;
import me.ahoo.pigeon.core.message.Message;

import java.util.concurrent.CompletableFuture;

/**
 * Message Bus
 *
 * @author ahoo wang
 * Creation time: 2019/11/19 11:07
 */
public interface MessageBus {
    /**
     * publish message
     *
     * @param message
     * @return
     */
    CompletableFuture<PublishResult> publish(Message message);

    /**
     * register subscribe
     *
     * @param subscriber
     */
    void subscribe(Subscriber subscriber);
}
