package me.ahoo.pigeon.core.bus;

import me.ahoo.pigeon.core.message.RouteDirection;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * @author ahoo wang
 * Creation time: 2019/11/22 15:14
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD, ElementType.TYPE})
public @interface Subscribe {
    /**
     * The name of Subscriber
     *
     * @return
     */
    String name() default "";

    RouteDirection direction() default RouteDirection.NULL;

    String commandType() default "";

    String groupId() default "";
}
