package me.ahoo.pigeon.core.bus.subscriber;

import lombok.extern.slf4j.Slf4j;
import lombok.var;
import me.ahoo.pigeon.core.message.Message;

/**
 * @author ahoo wang
 * Creation time: 2019/11/22 16:55
 */
@FunctionalInterface
public interface ExceptionHandler {
    ExceptionHandler LOGGER = new LoggerExceptionHandler();

    void handle(Subscriber subscriber, Message message, Throwable exception);

    @Slf4j
    class LoggerExceptionHandler implements ExceptionHandler {

        @Override
        public void handle(Subscriber subscriber, Message message, Throwable exception) {
            var errorMsg = String.format("Exception thrown by subscriber method:[%s],on subscriber:[%s],when dispatching message->id:[%s] ,direction:[%s],commandType:[%s]"
                    , subscriber.getMethod().getName()
                    , subscriber.getTarget().getClass().getName()
                    , message.getHeader().getId(false), message.getDirection(false), message.getCommandType(false));
            log.error(errorMsg, exception);
        }
    }
}
