package me.ahoo.pigeon.core.bus.subscriber;

import me.ahoo.pigeon.core.message.Message;
import me.ahoo.pigeon.core.message.RouteDirection;

import java.lang.reflect.Method;
import java.util.Set;

/**
 * @author ahoo wang
 * Creation time: 2020/3/20 10:32
 */
public interface Subscriber {

    String getName();

    Object getTarget();

    Method getMethod();

    RouteDirection getDirection();

    String getCommandType();

    String getGroupId();

    Set<String> getTopics();

    /**
     * the connectorId can not be null when the direction is {@link RouteDirection#CONNECTOR}!
     *
     * @return
     */
    Integer getConnectorId();

    void invoke(Message message);

    ExceptionHandler getExceptionHandler();

}


