package me.ahoo.pigeon.core.bus.subscriber.impl;

import com.google.common.base.Strings;
import lombok.var;
import me.ahoo.pigeon.core.message.RouteDirection;
import me.ahoo.pigeon.core.Constants;
import me.ahoo.pigeon.core.bus.subscriber.SubscriberDefinition;
import me.ahoo.pigeon.core.bus.subscriber.SubscriberGroupIdParser;

/**
 * @author ahoo wang
 * Creation time 2020/10/19 22:43
 **/
public class DefaultSubscriberGroupIdParser implements SubscriberGroupIdParser {

    private final String groupPrefix;
    /**
     * {@link #groupPrefix}{@link RouteDirection#CONNECTOR}.{connectorId}
     */
    private final String connectorGroupIdFormat;
    /**
     * {@link #groupPrefix}}{@link RouteDirection#ROUTER}
     */
    private final String routerGroupId;

    public DefaultSubscriberGroupIdParser() {
        this(Constants.PIGEON_PREFIX);
    }

    public DefaultSubscriberGroupIdParser(String groupPrefix) {
        this.groupPrefix = groupPrefix;
        this.routerGroupId = groupPrefix + RouteDirection.ROUTER.name().toLowerCase();
        this.connectorGroupIdFormat = groupPrefix + RouteDirection.CONNECTOR.name().toLowerCase() + ".%s";
    }

    /**
     * Parse group id of {@link SubscriberDefinition}
     *
     * @param subscriberDefinition
     * @return
     */
    @Override
    public String parseGroupId(SubscriberDefinition subscriberDefinition) {
        if (!Strings.isNullOrEmpty(subscriberDefinition.getGroupId())) {
            return subscriberDefinition.getGroupId();
        }
        final var direction = subscriberDefinition.getDirection();
        switch (direction) {
            case CONNECTOR: {
                return Strings.lenientFormat(connectorGroupIdFormat, subscriberDefinition.getConnectorId());
            }
            case ROUTER: {
                return routerGroupId;
            }
            case COMMANDER: {
                return groupPrefix + subscriberDefinition.getCommandType();
            }
            default:
                throw new IllegalStateException("Unexpected value: " + direction);
        }
    }
}
