package me.ahoo.pigeon.core.bus.subscriber.impl;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import me.ahoo.pigeon.core.bus.subscriber.Subscriber;
import me.ahoo.pigeon.core.bus.subscriber.SubscriberRegistry;

import java.util.Set;

/**
 * @author ahoo wang
 * Creation time: 2019/11/22 15:14
 */
public class DefaultSubscriberRegistry implements SubscriberRegistry {
    /**
     * TDDO {@link java.util.concurrent.ConcurrentHashMap}
     */
    private final HashMultimap<String, Subscriber> topicMapSubscribers = HashMultimap.create();

    @Override
    public void register(Subscriber subscriber) {
        synchronized (topicMapSubscribers) {
            subscriber.getTopics().forEach(topic -> {
                topicMapSubscribers.put(topic, subscriber);
            });
        }
    }

    @Override
    public Set<Subscriber> getSubscribers(String topic) {
        synchronized (topicMapSubscribers) {
            return ImmutableSet.copyOf(topicMapSubscribers.get(topic));
        }
    }
}
