package me.ahoo.pigeon.core.bus.subscriber.support;

import me.ahoo.pigeon.core.codec.DecoderRegistrar;
import me.ahoo.pigeon.core.bus.subscriber.Subscriber;
import me.ahoo.pigeon.core.bus.subscriber.SubscriberFactory;
import me.ahoo.pigeon.core.bus.subscriber.SubscriberRegistry;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.Ordered;

/**
 * @author ahoo wang
 * Creation time: 2019/12/11 16:06
 */
public class ImSubscriberAnnotationBeanPostProcessor implements BeanPostProcessor, Ordered {

    private final SubscriberRegistry subscriberRegistry;
    private final SubscriberFactory subscriberFactory;
    private final DecoderRegistrar decoderRegistrar;

    public ImSubscriberAnnotationBeanPostProcessor(SubscriberRegistry subscriberRegistry, SubscriberFactory subscriberFactory, DecoderRegistrar decoderRegistrar) {
        this.subscriberRegistry = subscriberRegistry;
        this.subscriberFactory = subscriberFactory;
        this.decoderRegistrar = decoderRegistrar;
    }

    @Override
    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof Subscriber) {
            register0((Subscriber) bean);
            return bean;
        }
        subscriberFactory.getSubscribers(bean).forEach(this::register0);
        return bean;
    }


    @Override
    public int getOrder() {
        return Ordered.LOWEST_PRECEDENCE;
    }

    private void register0(Subscriber subscriber) {
        subscriberRegistry.register(subscriber);
        decoderRegistrar.register(subscriber);
    }
}
