package me.ahoo.pigeon.core.codec;

import lombok.var;
import me.ahoo.pigeon.core.message.MessageHeader;

/**
 * @author ahoo wang
 * Creation time: 2019/11/21 12:01
 */
public class CompositeStringToMessageDecoder extends StringToMessageDecoder<Object> {

    private final DecoderRegistrar decoderRegistrar;

    public CompositeStringToMessageDecoder(DecoderRegistrar decoderRegistrar) {
        this.decoderRegistrar = decoderRegistrar;
    }

    @Override
    public Object decodeBody(MessageHeader header, String bodyStr) {
        var commandType = header.getCommandType(true);
        var decoder = decoderRegistrar.find(commandType);
        return decoder.decodeBody(header, bodyStr);
    }
}
