package me.ahoo.pigeon.core.codec;

import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.SneakyThrows;
import lombok.var;
import me.ahoo.pigeon.core.message.Message;
import me.ahoo.pigeon.core.message.MessageHeader;
import me.ahoo.pigeon.core.util.ObjectMappers;

import java.util.Objects;

/**
 * @author ahoo wang
 * Creation time: 2019/11/21 10:25
 */
public class MessageToStringEncoder implements MessageEncoder<Object, String, String, String> {
    private final ObjectMapper objectMapper;

    public MessageToStringEncoder() {
        objectMapper = ObjectMappers.of();
    }

    @Override
    public String encode(Message message) {

        StringMessageBag stringMessageBag = new StringMessageBag();

        var headerStr = encodeHeader(message.getHeader());
        stringMessageBag.setHeader(headerStr);

        String bodyStr = encodeBody(message.getBody());
        stringMessageBag.setBody(bodyStr);
        return stringMessageBag.toSource();
    }

    @SneakyThrows
    @Override
    public String encodeHeader(MessageHeader messageHeader) {
        return objectMapper.writeValueAsString(messageHeader);
    }

    @SneakyThrows
    @Override
    public String encodeBody(Object messageBody) {
        if (Objects.isNull(messageBody)) {
            return null;
        }
        if (String.class.isInstance(messageBody)) {
            return messageBody.toString();
        }
        return objectMapper.writeValueAsString(messageBody);
    }
}
