package me.ahoo.pigeon.core.codec;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import lombok.Getter;
import lombok.Setter;
import lombok.var;

import java.util.Objects;

/**
 * @author ahoo wang
 * Creation time: 2019/12/3 22:23
 */

public class StringMessageBag implements SourceMessageBag<String, String, String> {
    public final static String HEADER_SEPARATOR_BODY = "\n";
    private static final int TWO = 2;
    @Getter
    @Setter
    private String header;
    @Getter
    @Setter
    private String body;

    public StringMessageBag() {
    }

    public StringMessageBag(String messageStr) {
        Preconditions.checkState(!Strings.isNullOrEmpty(messageStr), "messageStr can not be empty.");
        var messages = messageStr.split(HEADER_SEPARATOR_BODY, 2);
        header = messages[0];
        if (messages.length == TWO) {
            body = messages[1];
        } else {
            body = null;
        }
    }

    @Override
    public String toSource() {
        if (Objects.isNull(body)) {
            return header;
        }
        return header + HEADER_SEPARATOR_BODY + body;
    }

    @Override
    public String toString() {
        return "StringMessageBag{" +
                "header='" + header + '\'' +
                ", body='" + body + '\'' +
                '}';
    }
}
