package me.ahoo.pigeon.core.connector;

import com.google.common.base.Preconditions;

/**
 * for k8s
 *
 * @author ahoo wang
 */
public class StatefulSetConnectorIdProvider implements ConnectorIdProvider {
    public static final String HOSTNAME_KEY = "HOSTNAME";

    @Override
    public ConnectorId get() {
        String hostName = System.getenv(HOSTNAME_KEY);
        Preconditions.checkNotNull(hostName, "HOSTNAME can not be null.");
        int lastSplitIdx = hostName.lastIndexOf("-");

        String idStr = hostName.substring(lastSplitIdx + 1);
        int id = Integer.parseInt(idStr);
        final ConnectorId connectorId = new ConnectorId();
        connectorId.setId(id);
        return connectorId;
    }

}
