package me.ahoo.pigeon.core.exception;

/**
 * @author ahoo wang
 * Creation time: 2019/11/21 18:33
 */
public class PigeonException extends RuntimeException {
    private final String code;

    public PigeonException(String code) {
        this.code = code;
    }

    public PigeonException(String code, String msg) {
        super(msg);
        this.code = code;
    }

    public PigeonException(String code, String msg, Throwable cause) {
        super(msg, cause);
        this.code = code;
    }

    public PigeonException(String code, String msg, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
        super(msg, cause, enableSuppression, writableStackTrace);
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }
}
