package me.ahoo.pigeon.core.expression;

import org.springframework.expression.Expression;
import org.springframework.expression.common.TemplateParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;

/**
 * @author ahoo wang
 * create time 2020/6/18 20:52
 */
public class SpringExpression implements StringExpression {

    private final String template;
    private final Expression expression;

    public SpringExpression(String template) {
        this.template = template;
        this.expression = new SpelExpressionParser().parseExpression(template, TemplateParserContext.TEMPLATE_EXPRESSION);
    }

    @Override
    public String parse(Object key) {
        return expression.getValue(key, String.class);
    }

    @Override
    public String toString() {
        return "SpringExpression{" +
                "template='" + template + '\'' +
                '}';
    }
}
