package me.ahoo.pigeon.core.id.impl;

import lombok.Builder;
import lombok.Getter;

import java.time.LocalDateTime;
import java.util.Objects;

/**
 * @author ahoo wang
 * Creation time: 2019/12/4 21:25
 */
@Builder
public class SnowflakeIdState {
    @Getter
    private final long id;
    @Getter
    private final int machineId;
    @Getter
    private final long sequence;
    @Getter
    private final LocalDateTime timestamp;
    @Getter
    private final String friendlyId;

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (Objects.isNull(other) || !getClass().isInstance(other)) {
            return false;
        }
        SnowflakeIdState that = (SnowflakeIdState) other;
        return id == that.id;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(id);
    }

    @Override
    public String toString() {
        return friendlyId;
    }
}
