package me.ahoo.pigeon.core.message;


/**
 * Internal command type
 *
 * @author ahoo wang
 * Creation time: 2019/12/6 11:03
 */
public class CommandTypes {

    //region Connector-Server-Type

    public static final String ERROR = "error";
    public static final String CONNECTOR_STARTED = "connector_started";
    public static final String CONNECTOR_STOPPED = "connector_stopped";

    //endregion

    //region Link-Type

    public static final String IDLE = "idle";
    public static final String HEARTBEAT = "heartbeat";
    public static final String DEVICE_DISCONNECTED = "device_disconnected";
    public static final String USER_DISCONNECTED = "user_disconnected";
    //endregion

    //region Bind-Type Succeeded failed

    public static final String AUTH = "auth";
    public static final String AUTH_SUCCEEDED = "auth_succeeded";
    public static final String AUTH_FAILED = "auth_failed";

    public static final String DEVICE_BIND = "device_bind";
    public static final String DEVICE_BIND_SUCCEEDED = "device_bind_succeeded";

    public static final String ROOM_JOIN = "room_join";
    public static final String ROOM_JOIN_SUCCEEDED = "room_join_succeeded";
    public static final String ROOM_JOIN_FAILED = "room_join_failed";
    public static final String ROOM_LEAVE = "room_leave";
    //endregion

    //region ACK

    /**
     * 客户端接收到服务端发送的消息,客户端之后发送 ACK 请求给服务端
     */
    public static final String CLIENT_ACK = "client_ack";
    /**
     * 服务端接收到客户端发送的消息,服务端之后发送 ACK 请求给客户端
     */
    public static final String SERVER_ACK = "server_ack";

    //endregion

    //endregion


}
