package me.ahoo.pigeon.core.message;

/**
 * 消息路由的方向
 * Demo Chat RouteDirection: CLIENT -&gt; CONNECTOR -&gt; COMMANDER -&gt; ROUTER -&gt; CONNECTOR -&gt; CLIENT
 *
 * @author ahoo wang
 * Creation time: 2019/12/5 18:56
 */
public enum RouteDirection {
    /**
     * No direction
     */
    NULL(0),
    /**
     * Next To Client
     */
    CLIENT(1),
    /**
     * Next To Connector Server
     */
    CONNECTOR(2),
    /**
     * Next To Commander Service
     */
    COMMANDER(3),
    /**
     * Next To Router Server
     */
    ROUTER(4);

    private int value;

    RouteDirection(int value) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }

    public static RouteDirection valueOf(int value) {
        switch (value) {
            case 0: {
                return NULL;
            }
            case 1: {
                return CLIENT;
            }
            case 2: {
                return CONNECTOR;
            }
            case 3: {
                return COMMANDER;
            }
            case 4: {
                return ROUTER;
            }
            default:
                throw new IllegalStateException("Unexpected value: " + value);
        }
    }
}
