package me.ahoo.pigeon.core.message;

/**
 * TODO add support Mixed mode
 * @author ahoo wang
 * Creation time: 2019/12/20 12:46
 */
public enum SendMode {
    /**
     * Broadcast message to everyone
     */
    BROADCAST(0),
    /**
     * Only send to channel
     */
    TO_CHANNEL(1),
    /**
     * Send to device
     */
    TO_DEVICE(2),
    /**
     * Send to user
     */
    TO_USER(3),
    /**
     * Send to group
     */
    TO_GROUP(4),
    /**
     * Send to room
     */
    TO_ROOM(5);

    public static final SendMode DEFAULT = TO_USER;

    private int value;

    SendMode(int value) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }

    public static SendMode valueOf(int value) {
        switch (value) {
            case 0: {
                return SendMode.BROADCAST;
            }
            case 1: {
                return SendMode.TO_CHANNEL;
            }
            case 2: {
                return SendMode.TO_DEVICE;
            }
            case 3: {
                return SendMode.TO_USER;
            }
            case 4: {
                return SendMode.TO_GROUP;
            }
            case 5: {
                return SendMode.TO_ROOM;
            }
            default:
                throw new IllegalStateException("Unexpected value: " + value);
        }
    }
}
