package me.ahoo.pigeon.core.relation;

import java.util.Set;

/**
 * Connector 1 - n User
 *
 * @author ahoo wang
 * Creation time: 2020/3/12 13:05
 */
public interface ConnectorUserRelationService {

    /**
     * Connector 关闭时触发
     *
     * @param connectorId
     * @return
     */
    Boolean connectorStop(Integer connectorId);

    /**
     * 用户连接到 Connector 时持久化关系数据
     *
     * @param connectorId
     * @param userId
     * @return
     */
    Long connectUser(Integer connectorId, Long userId);

    /**
     * 用户断开连接时 移除 持久化数据
     *
     * @param connectorId
     * @param userId
     * @return
     */
    Long disconnectUser(Integer connectorId, Long userId);

    /**
     * 获取 连接到 Connector 的用户数
     *
     * @param connectorId
     * @return
     */
    Long getConnectorUserStat(Integer connectorId);


    /**
     * demo:
     * 通过 Connector_User Intersection Group_User 找到 Online UserIds
     *
     * @param connectorId connectorId
     * @param groupId     groupId
     * @return UserIds
     */
    Set<Long> findConnectorUserInGroup(Integer connectorId, Long groupId);

}
