package me.ahoo.pigeon.core.relation;

import java.util.Set;

/**
 * Device 1 - n Connector
 *
 * @author ahoo wang
 * Creation time: 2020/3/12 13:05
 */
public interface DeviceConnectorRelationService {

    /**
     * 设备连接到 Connector 时持久化 Device 与 Connector 关系
     *
     * @param deviceId
     * @param connectorId
     * @return
     */
    Long deviceConnect(Long deviceId, Integer connectorId);

    /**
     * 设备断开连接时移除持久化数据
     *
     * @param deviceId
     * @param connectorId
     * @return
     */
    Long deviceDisconnect(Long deviceId, Integer connectorId);

    /**
     * 获取设备绑定的 Connector
     *
     * @param deviceId
     * @return
     */
    Set<Integer> findDeviceConnector(Long deviceId);

    /**
     * 获取设备绑定的 Connector 数
     *
     * @param deviceId
     * @return
     */
    Long getDeviceConnectorStat(Long deviceId);
}
