package me.ahoo.pigeon.core.relation;

import java.util.Set;

/**
 * Group 1 - n User
 *
 * @author ahoo wang
 * Creation time: 2020/3/12 13:04
 */
public interface GroupUserRelationService {

    /**
     * 删除 Group
     *
     * @param groupId
     * @return
     */
    Boolean groupRemove(Long groupId);

    /**
     * 用户加入组时持久化 Group 与 User关系
     *
     * @param groupId
     * @param userId
     * @return
     */
    Long groupJoin(Long groupId, Long userId);

    /**
     * 用户推出组时移除持久化关系
     *
     * @param groupId
     * @param userId
     * @return
     */
    Long groupLeave(Long groupId, Long userId);

    /**
     * 判断用户是否在组中
     *
     * @param groupId
     * @param userId
     * @return
     */
    Boolean groupIn(Long groupId, Long userId);

    /**
     * 获取组内用户
     *
     * @param groupId
     * @return
     */
    Set<Long> findGroupUser(Long groupId);

    /**
     * 获取组内用户数
     *
     * @param groupId
     * @return
     */
    Long getGroupUserStat(Long groupId);

}
