package me.ahoo.pigeon.core.relation;

import java.util.Set;

/**
 * @author ahoo wang
 * Creation time: 2020/3/13 9:23
 */
public interface RoomConnectorRelationService {

    /**
     * 用户通道加入 Room 时持久化 Room 与 Connector 关系
     *
     * @param roomId
     * @param connectorId
     * @return
     */
    Long roomJoin(Long roomId, Integer connectorId);

    /**
     * 用户通道离开 Room 时移除关系
     *
     * @param roomId
     * @param connectorId
     * @return
     */
    Long roomLeave(Long roomId, Integer connectorId);

    /**
     * 获取 Room 所在的 Connector
     *
     * @param roomId
     * @return
     */
    Set<Integer> findRoomConnector(Long roomId);

    /**
     * 获取 Room 所在的 Connector 数
     *
     * @param roomId
     * @return
     */
    Long getRoomConnectorStat(Long roomId);
}
