package me.ahoo.pigeon.core.relation;

import java.util.Set;

/**
 * User 1 - n Connector
 *
 * @author ahoo wang
 * Creation time: 2020/3/12 13:05
 */
public interface UserConnectorRelationService {

    /**
     * 用户连接到 Connector 时 持久化 User 与 Connector 关系
     * @param userId
     * @param connectorId
     * @return
     */
    Long userConnect(Long userId, Integer connectorId);

    /**
     * 用户断开连接时移除关系
     * @param userId
     * @param connectorId
     * @return
     */
    Long userDisconnect(Long userId, Integer connectorId);

    /**
     * 获取用户所在的 Connector
     * @param userId
     * @return
     */
    Set<Integer> findUserConnector(Long userId);

    /**
     * 获取用户所在的 Connector 数
     * @param userId
     * @return
     */
    Long getUserConnectorStat(Long userId);
}
