package me.ahoo.pigeon.core.security;

import me.ahoo.pigeon.core.security.authorization.Device;
import me.ahoo.pigeon.core.security.authorization.User;

import java.net.SocketAddress;

/**
 * @author ahoo wang
 * Creation time 2020/10/15 22:17
 **/
public interface SecurityContext {

    /**
     * 获取当前绑定的用户
     *
     * @return current User
     */
    User getUser();

    /**
     * 获取当前绑定的设备
     *
     * @return current Device
     */
    Device getDevice();

    /**
     * Get client address
     *
     * @return client address
     */
    SocketAddress remoteAddress();
}
