package me.ahoo.pigeon.core.security.authorization;

import com.google.common.base.Preconditions;
import lombok.var;
import me.ahoo.pigeon.core.exception.PigeonException;
import me.ahoo.pigeon.core.message.Message;
import me.ahoo.pigeon.core.security.SecurityContext;

import java.util.List;

/**
 * @author ahoo wang
 * Creation time: 2019/11/22 23:02
 * 组合模式的认证
 */
public class CompositeAuthorization implements UserAuthorization {

    private final List<AuthorizationSupport> delegates;

    public CompositeAuthorization(List<AuthorizationSupport> delegates) {
        Preconditions.checkState(!delegates.isEmpty(), "AuthorizationSupports can not be empty.");
        this.delegates = delegates;
    }

    @Override
    public AuthorizeResult<User> authorize(SecurityContext securityContext, Message authRequest) {
        var delegate = delegates.stream()
                .filter(d -> d.support(authRequest))
                .findFirst();
        if (!delegate.isPresent()) {
            throw new PigeonException("authorize-0000", String.format("CompositeAuthorization can not find any Authorization for Message.Id:[%s]", authRequest.getHeader().getId(false)));
        }

        return delegate.get().authorize(securityContext, authRequest);
    }
}
