package me.ahoo.pigeon.core.security.authorization;

import com.google.common.collect.ImmutableMap;
import lombok.*;

/**
 * User 1:n Device
 *
 * @author : ahoo wang
 * Creation time:: 2019/11/13 17:19
 */
@Getter
@Builder
public class User {
    private final Long id;
    private final String username;
    private final String nickname;
    private final String avatar;
    private final String role;
    private ImmutableMap<String, Object> attr;

    @Override
    public String toString() {
        return "User{" +
                "id=" + id +
                ", username='" + username + '\'' +
                ", nickname='" + nickname + '\'' +
                ", avatar='" + avatar + '\'' +
                ", role='" + role + '\'' +
                '}';
    }
}
