package me.ahoo.pigeon.core.security.authorization.jwt;

import lombok.extern.slf4j.Slf4j;
import lombok.var;
import me.ahoo.pigeon.core.message.Message;
import me.ahoo.pigeon.core.message.MessageHeader;
import me.ahoo.pigeon.core.security.authorization.jwt.config.DeviceConfig;
import me.ahoo.pigeon.core.security.SecurityContext;
import me.ahoo.pigeon.core.security.authorization.AuthorizeResult;
import me.ahoo.pigeon.core.security.authorization.Device;
import me.ahoo.pigeon.core.security.authorization.DeviceAuthorization;
import me.ahoo.pigeon.core.security.device.DeviceRegistrar;

import java.util.Objects;

/**
 * @author ahoo wang
 * Creation time: 2019/12/26 10:54
 */
@Slf4j
public class JwtDeviceAuthorization implements DeviceAuthorization {
    private final JwtProvider jwtProvider;

    private final DeviceRegistrar deviceRegistrar;

    public JwtDeviceAuthorization(DeviceRegistrar deviceRegistrar, DeviceConfig deviceConfig) {
        this.deviceRegistrar = deviceRegistrar;
        jwtProvider = new JwtProvider(deviceConfig.getAlgName(), deviceConfig.getSecretKey(), deviceConfig.getValidityTime());
    }

    @Override
    public AuthorizeResult<Device> authorize(SecurityContext securityContext, Message authMessage) {
        var jwtToken = authMessage.getHeader().get(MessageHeader.Headers.AUTH);
        Device device = null;
        if (Objects.nonNull(jwtToken)) {
            try {
                device = jwtProvider.parseDevice(jwtToken.toString());
            } catch (Throwable throwable) {
                if (log.isInfoEnabled()) {
                    log.info("parseDevice failure:{}", throwable.getMessage());
                }
            }
        }
        if (Objects.isNull(device)) {
            device = deviceRegistrar.register(authMessage);
        }
        var deviceToken = jwtProvider.parseDeviceToken(device);
        return AuthorizeResult.<Device>builder().accessToken(deviceToken).body(device).build();
    }
}
