package me.ahoo.pigeon.core.security.authorization.jwt;

import lombok.extern.slf4j.Slf4j;
import lombok.var;
import me.ahoo.pigeon.core.message.Message;
import me.ahoo.pigeon.core.message.MessageHeader;
import me.ahoo.pigeon.core.security.authorization.jwt.config.RoomConfig;
import me.ahoo.pigeon.core.security.SecurityContext;
import me.ahoo.pigeon.core.security.authorization.AuthorizeResult;
import me.ahoo.pigeon.core.security.authorization.Room;
import me.ahoo.pigeon.core.security.authorization.RoomAuthorization;

import java.util.Objects;

/**
 * @author ahoo wang
 * Creation time: 2019/12/26 10:54
 */
@Slf4j
public class JwtRoomAuthorization implements RoomAuthorization {
    private final JwtProvider jwtProvider;

    public JwtRoomAuthorization(RoomConfig roomConfig) {
        jwtProvider = new JwtProvider(roomConfig.getAlgName(), roomConfig.getSecretKey(), roomConfig.getValidityTime());
    }

    @Override
    public AuthorizeResult<Room> authorize(SecurityContext securityContext, Message authMessage) {
        var jwtToken = authMessage.getHeader().get(MessageHeader.Headers.AUTH);
        Room room = null;
        if (Objects.nonNull(jwtToken)) {
            try {
                room = jwtProvider.parseRoom(jwtToken.toString());
            } catch (Throwable throwable) {
                if (log.isInfoEnabled()) {
                    log.info("parseRoom failure:{}", throwable.getMessage());
                }
            }
        }
        return AuthorizeResult.<Room>builder().accessToken(jwtToken.toString()).body(room).build();
    }
}
