package me.ahoo.pigeon.core.security.authorization.none;

import lombok.var;
import me.ahoo.pigeon.core.message.Message;
import me.ahoo.pigeon.core.security.SecurityContext;
import me.ahoo.pigeon.core.security.authorization.AuthorizeResult;
import me.ahoo.pigeon.core.security.authorization.Device;
import me.ahoo.pigeon.core.security.authorization.DeviceAuthorization;
import me.ahoo.pigeon.core.security.device.DeviceRegistrar;

/**
 * @author ahoo wang
 * Creation time: 2019/12/26 11:46
 */
public class NoneDeviceAuthorization implements DeviceAuthorization {

    private final DeviceRegistrar deviceRegistrar;

    public NoneDeviceAuthorization(DeviceRegistrar deviceRegistrar){

        this.deviceRegistrar = deviceRegistrar;
    }
    @Override
    public AuthorizeResult<Device> authorize(SecurityContext securityContext, Message authMessage) {
        var device = deviceRegistrar.register(authMessage);
        return AuthorizeResult.<Device>builder().body(device).build();
    }
}
