package me.ahoo.pigeon.core.security.authorization.none;

import lombok.var;
import me.ahoo.pigeon.core.message.Message;
import me.ahoo.pigeon.core.security.SecurityContext;
import me.ahoo.pigeon.core.security.authorization.AuthorizeResult;
import me.ahoo.pigeon.core.security.authorization.Room;
import me.ahoo.pigeon.core.security.authorization.RoomAuthorization;

/**
 * @author ahoo wang
 * Creation time: 2019/11/21 21:05
 */
public class NoneRoomAuthorization implements RoomAuthorization {

    @Override
    public AuthorizeResult<Room> authorize(SecurityContext securityContext, Message message) {
        var roomId = message.getHeader().getReceiverRoomId(true);
        return AuthorizeResult.<Room>builder().body(Room.builder().id(roomId).name(roomId.toString()).build()).build();
    }
}
