package me.ahoo.pigeon.core.security.authorization.none;

import com.google.common.base.Joiner;
import lombok.var;
import me.ahoo.pigeon.core.message.Message;
import me.ahoo.pigeon.core.id.IdGenerator;
import me.ahoo.pigeon.core.security.SecurityContext;
import me.ahoo.pigeon.core.security.authorization.AuthorizeResult;
import me.ahoo.pigeon.core.security.authorization.User;
import me.ahoo.pigeon.core.security.authorization.UserAuthorization;

/**
 * @author ahoo wang
 * Creation time: 2019/11/21 21:05
 */
public class NoneUserAuthorization implements UserAuthorization {
    private final IdGenerator idGenerator;

    public NoneUserAuthorization(IdGenerator idGenerator) {

        this.idGenerator = idGenerator;
    }

    @Override
    public AuthorizeResult<User> authorize(SecurityContext securityContext, Message message) {
        var userId = idGenerator.generate();
        var username = Joiner.on("-").join("None", String.valueOf(userId));
        return AuthorizeResult.<User>builder().body(User.builder().id(userId).username(username).build()).build();
    }
}
