package me.ahoo.pigeon.core.security.command;

import me.ahoo.pigeon.core.message.Message;
import me.ahoo.pigeon.core.security.command.privilege.PrivilegeChecker;
import me.ahoo.pigeon.core.security.SecurityContext;

/**
 * @author ahoo wang
 * Creation time 2020/10/16 21:39
 **/
public class PrivilegeCommandAuthorization implements CommandAuthorization {
    private final PrivilegeChecker privilegeChecker;

    public PrivilegeCommandAuthorization(PrivilegeChecker privilegeChecker) {
        this.privilegeChecker = privilegeChecker;
    }

    @Override
    public boolean authorize(SecurityContext securityContext, Message message) {
        return privilegeChecker.check(securityContext, message.getCommandType(true));
    }
}
