package me.ahoo.pigeon.core.security.command;

import lombok.var;
import me.ahoo.pigeon.core.message.Message;
import me.ahoo.pigeon.core.security.SecurityContext;

import java.util.Set;

/**
 * {@link PrivilegeCommandAuthorization}
 *
 * @author ahoo wang
 * Creation time: 2020/4/16 15:42
 */
public class WhitelistCommandAuthorization implements CommandAuthorization {

    private static final String ASTERISK = "*";
    private final boolean allowAll;
    private final Set<String> cmdWhitelist;

    public WhitelistCommandAuthorization(Set<String> cmdWhitelist) {
        var firstCmdOp = cmdWhitelist.stream().findFirst();
        if (firstCmdOp.isPresent()) {
            allowAll = ASTERISK.equals(firstCmdOp.get());
        } else {
            allowAll = false;
        }
        this.cmdWhitelist = cmdWhitelist;
    }

    @Override
    public boolean authorize(SecurityContext securityContext, Message message) {
        if (allowAll) {
            return true;
        }

        return cmdWhitelist.contains(message.getCommandType(true));
    }
}
