package me.ahoo.pigeon.core.security.command.mather;

import lombok.var;

/**
 * @author ahoo wang
 * Creation time 2020/10/16 21:04
 **/
public final class CommandMatcherFactory {

    public static final String WILDCARD = "*";

    public static CommandMatcher of(String commandMatch) {

        if (WILDCARD.equals(commandMatch)) {
            return TrueCommandMatcher.INSTANCE;
        }

        if (commandMatch.startsWith(WILDCARD) && commandMatch.endsWith(WILDCARD)) {
            var substring = commandMatch.substring(1, commandMatch.length() - 1);
            return new ContainsCommandMatcher(substring);
        }

        if (commandMatch.startsWith(WILDCARD)) {
            var suffix = commandMatch.substring(1);
            return new SuffixCommandMatcher(suffix);
        }

        if (commandMatch.endsWith(WILDCARD)) {
            var prefix = commandMatch.substring(0, commandMatch.length() - 1);
            return new PrefixCommandMatcher(prefix);
        }


        return new EqualCommandMatcher(commandMatch);
    }
}
