package me.ahoo.pigeon.core.security.command.privilege;

import me.ahoo.pigeon.core.security.SecurityContext;
import me.ahoo.pigeon.core.security.command.mather.CommandMatcher;
import me.ahoo.pigeon.core.security.command.mather.TrueCommandMatcher;

import java.util.List;

/**
 * @author ahoo wang
 * Creation time 2020/10/16 21:43
 **/
public class CommandPrivilegeChecker implements PrivilegeChecker {

    private final boolean allowAll;
    private final List<CommandMatcher> commandMatchers;

    public CommandPrivilegeChecker(List<CommandMatcher> commandMatchers) {
        this.commandMatchers = commandMatchers;
        this.allowAll = commandMatchers.stream().anyMatch(commandMatcher -> commandMatcher instanceof TrueCommandMatcher);
    }

    @Override
    public boolean check(SecurityContext securityContext, String commandType) {
        if (allowAll) {
            return true;
        }
        return commandMatchers.stream()
                .anyMatch(commandMatch -> commandMatch.isMatch(commandType));
    }

}
